<!DOCTYPE html>
<!--[if lt IE 7]>      <html class="no-js lt-ie9 lt-ie8 lt-ie7" lang="en"> <![endif]-->
<!--[if IE 7]>         <html class="no-js lt-ie9 lt-ie8" lang="en"> <![endif]-->
<!--[if IE 8]>         <html class="no-js lt-ie9" lang="en"> <![endif]-->
<!--[if gt IE 8]><!--> <html class="no-js" lang="en"> <!--<![endif]-->
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $config['title']; ?></title>
    <meta name="description" content="<?php echo $config['description']; ?>">
    
    <!-- Le HTML5 shim, for IE6-8 support of HTML5 elements -->
    <!--[if lt IE 9]>
      <script src="assets/js/html5shiv.js"></script>
    <![endif]-->

    <link href='http://fonts.googleapis.com/css?family=Righteous|Open+Sans:400,400italic,700,700italic&amp;subset=latin,latin-ext,cyrillic-ext,greek,cyrillic,greek-ext,vietnamese' rel='stylesheet' type='text/css'>
    <link href="<?php echo $config['site_url']; ?>/views/<?php echo $config['style']; ?>/assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="<?php echo $config['site_url']; ?>/views/<?php echo $config['style']; ?>/assets/css/bootstrap-responsive.min.css" rel="stylesheet">
    <link href="<?php echo $config['site_url']; ?>/views/<?php echo $config['style']; ?>/assets/css/style.css" rel="stylesheet">
    <link rel="shortcut icon" href="<?php echo $config['site_url']; ?>/favicon.ico">

    <?php echo htmlspecialchars_decode($config['head_code']); ?>
    
</head>
<body>

    <div class="navbar navbar-fixed-top">
        <div class="navbar-inner">
            <div class="container">
                <a class="btn btn-navbar" data-toggle="collapse" data-target=".nav-collapse">
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                </a>
                <a class="brand" href="<?php echo $config['site_url']; ?>"><?php echo $config['site_name']; ?></a>
                <div class="nav-collapse" id="main-menu">
                    <div class="pull-right">
                        <ul class="nav" id="main-menu-right">
                            <li><a href="<?php echo $config['site_url']; ?>/"><?php echo $lang['menu_home']; ?></a></li>
                            <li><a href="<?php echo $config['site_url']; ?>/page/about/"><?php echo $lang['menu_about']; ?></a></li>
                            <li><a href="<?php echo $config['site_url']; ?>/page/contact/"><?php echo $lang['menu_contact']; ?></a></li>
                        </ul>
                        <form class="navbar-search" action="<?php echo $config['site_url']; ?>/redirect.php" method="post">
                            <input class="search-query span2" placeholder="<?php echo $lang['search_placeholder']; ?>" name="url" type="text">
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <?php include $path; ?>

    
    <!--
    ============================================================ -->
    <div class="container">
        <div class="ad_area_two hidden-phone text-center"><?php echo $config['ad_area_two']; ?></div>
        <hr>
        <footer id="footer">   
            <div class="pull-left">
            <div class="links">
                <a href="<?php echo $config['site_url']; ?>/page/about/"><?php echo $lang['menu_about']; ?></a> &nbsp; &nbsp; 
                <a href="<?php echo $config['site_url']; ?>/page/contact/"><?php echo $lang['menu_contact']; ?></a> &nbsp; &nbsp; 
                <a href="<?php echo $config['site_url']; ?>/page/terms/"><?php echo $lang['menu_terms']; ?></a> &nbsp; &nbsp; 
                <a href="<?php echo $config['site_url']; ?>/page/privacy/"><?php echo $lang['menu_privacy']; ?></a>          
            </div>
            <p> <?php echo replace(array('site_name' => $config['site_name']), $lang['copyright_text']); ?> Powered By <a href="http://www.webscanup.com/">WebScanUp Domain Reviewer</a></p>
        </div>

            <div class="pull-right text-right">
                <a href="javascript:void(0)" class="backtotop"><?php echo $lang['misc_back_to_top']; ?></a><br />
                <a href='http://pagepeeker.com/' target='_blank'>Website Screenshots by PagePeeker</a> 
            </div>

        </footer>

    </div><!-- /container -->



    <!-- Le javascript
    ================================================== -->
    <!-- Placed at the end of the document so the pages load faster -->
    <script src="//ajax.googleapis.com/ajax/libs/jquery/1.9.0/jquery.min.js"></script>
    <script>window.jQuery || document.write('<script src="<?php echo $config['site_url']; ?>/views/<?php echo $config['style']; ?>/assets/js/vendor/jquery-1.9.0.min.js"><\/script>')</script>
    <script src="<?php echo $config['site_url']; ?>/views/<?php echo $config['style']; ?>/assets/js/bootstrap.min.js"></script>
    <script type="text/javascript">
        jQuery('.backtotop').click(function(){
            jQuery('html, body').animate({scrollTop:0}, 'slow');
        });
    </script>

  </body>
</html>